# encoding:UTF-8
import json
import requests
from requests_toolbelt.multipart.encoder import MultipartEncoder

# 请替换XXXXXXXXXXX:XXXXXXXXX为您的 APIpassword, 获取地址：https://console.xfyun.cn/services/bmx1
api_key = "Bearer XXXXXXXXXXX:XXXXXXXXX"


#创建知识库
def createKB(uid,name):
    
    url = 'https://sparkcons-rag-gray.cn-huabei-1.xf-yun.com/aiuiKnowledge/rag/api/repo/create'
    headers = {
        'Authorization': api_key,
        'content-type': "application/json"
    }
    body = {
        "uid": uid,
        "name": name,
        "description": "这里是一段知识库的描述"

    }

    response = requests.post(url=url, json=body, headers=headers, stream=True).text
    print(response)


# 上传文档
def upload(uid,filePath,groupId):
    url = 'https://sparkcons-rag-gray.cn-huabei-1.xf-yun.com/aiuiKnowledge/rag/api/doc/saveRepoDoc'    
    # 通过文件流的方式上传
    formData = MultipartEncoder(
        fields={
            "file": (filePath, open(filePath, 'rb'), 'text/plain'),
            "uid": str(uid),  # 管理文档的uid
            # "repoId": str(repoId),  # 需要将文档上传到对应的知识库id
            "groupId":groupId,
        }
    )
    print(formData)
    headers = {
        'Authorization': api_key,
        "Content-Type": formData.content_type
    }

    response = requests.post(url= url,data= formData,headers=headers).text

    return response

# 绑定知识库和应用
def connect(uid,appid,groupID):
    url = 'https://sparkcons-rag-gray.cn-huabei-1.xf-yun.com/aiuiKnowledge/rag/api/app/saveRepoConfig'
    headers = {
        'Authorization': api_key,
        'content-type': "application/json"
    }
    body = {
        "uid": uid,
        "appId": appid,
        "sceneName": "sos_app",
        "repos": [
            {
                "groupId": groupID
            }
        ]
    }
    print(body)
    response = requests.post(url= url,json= body,headers=headers).text
    print(response)


#主程序入口
if __name__ =='__main__':

    ###############
    ### 开始运行之前，请仔细阅读以下步骤：
    ###1、请先从控制台（https://console.xfyun.cn/services/VCN） 获取APIpassword和 appid, 分别填写在第7行和第98行
    ###2、该py文件中写的方法比较过，请按照下面标出的步骤依次执行，注意每次只能执行一个步骤，其他步骤需要注掉；
    ###3、该脚本仅针对需要在超拟人交互中上传自己的个性化知识库场景；
    ###############


    # 步骤一：创建知识库,分别传入自定义的uid（整型long） 和知识库名称（string）
    KBtest = createKB('1015','KB_lxk1015')

    
    # 步骤二：上传文档(需要填写好filepath 和 groupId)
    # groupID= "这里填写步骤1返回的groupId"
    # # 文件路径
    # filepath = 'demo_Python(a2a)\\resource\\2022中国大模型发展白皮书.pdf'
    # # 上传文档
    # print(upload(1015,filepath,groupID))


    # 步骤三：绑定知识库和应用，执行前请替换XXXXXXXX为appid
    
    # connect(1015,"XXXXXXXX",groupID)

