package com.black;

import cn.hutool.json.JSONObject;
import com.google.gson.Gson;
import jdk.nashorn.internal.parser.JSONParser;
import okhttp3.*;

import java.io.File;
import java.io.IOException;
import java.util.List;


public class KnowledgeBase {
    private String uid;
    private String name;
    private String description = "知识库";
    public static String SCENE_NAME = "sos_app";
    public static String UID = "1016";
    private static final String CREATE_URL = "https://sparkcons-rag-gray.cn-huabei-1.xf-yun.com/aiuiKnowledge/rag/api/repo/create";
    private static final String UPLOAD_URL = "https://sparkcons-rag-gray.cn-huabei-1.xf-yun.com/aiuiKnowledge/rag/api/doc/saveRepoDoc";
    private static final String SAVE_REPO_URL = "https://sparkcons-rag-gray.cn-huabei-1.xf-yun.com/aiuiKnowledge/rag/api/app/saveRepoConfig";
    private static final String REPO_DETAIL_URL = "https://sparkcons-rag.cn-huabei-1.xf-yun.com/aiuiKnowledge/rag/api/app/getRepoConfig";
    public static final String DELETE_REPO_URL = "https://sparkcons-rag.cn-huabei-1.xf-yun.com/aiuiKnowledge/rag/api/repo/file/delete";

    public static String APPID = "xxx";
    public static String API_KEY = "Bearer xxx";
    public static Gson gson = new Gson();

    public KnowledgeBase(String uid, String name) {
        this.uid = uid;
        this.name = name;
    }

    /*主入口*/
    public static void main(String[] args) throws Exception {
        // 第一步创建知识库（不用每次都执行）
        // 自定义的uid（整型long）
        String createRes = createKnowledgeBase(UID, "my_database_1");
        System.out.println("第一步---创建知识库：" + createRes);
        JsonParse1 jsonParse1 = gson.fromJson(createRes, JsonParse1.class);
        String groupId = jsonParse1.data.groupId;
        System.out.println("创建的库ID为：" + groupId);
        // 第二步上传文档（替换实际的文档路径）
        String filePath = "src/main/resources/1.txt";
        String uploadRes = upload(UID, filePath, groupId);
        System.err.println("************************************************************************************");
        System.out.println("第二步---上传文档：" + uploadRes);
        // 第三步 APPID应用和知识库绑定
        String connectRes = connect(UID, APPID, groupId);
        System.err.println("************************************************************************************");
        System.out.println("第三步---绑定返回的信息：" + connectRes);
        // 第四步 查询知识库信息
        String detailRes = queryRepoDetail(UID);
        System.err.println("************************************************************************************");
        System.out.println("第四步---查询知识库信息：" + detailRes);


        // 第五步
        /*String deleteRes = deleteRepoOrFile(UID, "group_cab0699a7a57b974489c83be", "26a6ecad29014d27a9d5a31e75fdb6ee");
        System.err.println("************************************************************************************");
        System.out.println("第五步---删除知识库或文件：" + deleteRes);*/

        // 第五步 批量删除所有的知识库和文件，慎用！！！
        /*JsonParse2 jsonParser2 = gson.fromJson(detailRes, JsonParse2.class);
        List<Repos> reposList = jsonParser2.data.repos;
        for (Repos tempRepos : reposList) {
            String tempGroupId = tempRepos.groupId;
            List<DocList> docListList = tempRepos.docList;
            for (DocList tempDocList : docListList) {
                String deleteRes = deleteRepoOrFile(UID, tempGroupId, tempDocList.docid);
                System.err.println("************************************************************************************");
                System.out.println("第五步---删除知识库或文件：" + deleteRes);
            }
        }*/
    }

    // 1.创建知识库
    public static String createKnowledgeBase(String uid, String name) throws IOException {
        OkHttpClient client = new OkHttpClient();
        RequestBody requestBody = RequestBody.create(new Gson().toJson(new KnowledgeBase(uid, name)), MediaType.parse("application/json"));
        Request request = new Request.Builder().url(CREATE_URL).post(requestBody).addHeader("Authorization", API_KEY).addHeader("content-type", "application/json").build();
        try (Response response = client.newCall(request).execute()) {
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            return response.body().string();
        }
    }

    // 2.上传文档
    public static String upload(String uid, String filePath, String groupId) throws IOException {
        File file = new File(filePath);
        //  or appropriate media type
        RequestBody fileBody = RequestBody.create(file, MediaType.parse("text/plain"));
        // Create multipart form data
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), fileBody).addFormDataPart("uid", uid).addFormDataPart("groupId", groupId);
        RequestBody requestBody = builder.build();
        // Build the request
        Request request = new Request.Builder().url(UPLOAD_URL).header("Authorization", API_KEY).post(requestBody).build();
        OkHttpClient client = new OkHttpClient();
        try (Response response = client.newCall(request).execute()) {
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            return response.body().string();
        }
    }

    // 3.APPID应用和知识库绑定
    public static String connect(String uid, String appId, String groupID) throws IOException {
        JSONObject requestBody = new JSONObject();
        requestBody.put("uid", uid);
        requestBody.put("appId", appId);
        requestBody.put("sceneName", SCENE_NAME);

        JSONObject repo = new JSONObject();
        repo.put("groupId", groupID);
        requestBody.put("repos", new JSONObject[]{repo});
        // System.out.println(requestBody.toString());

        OkHttpClient client = new OkHttpClient();
        MediaType JSON = MediaType.parse("application/json; charset=utf-8");
        RequestBody body = RequestBody.create(requestBody.toString(), JSON);
        Request request = new Request.Builder().url(SAVE_REPO_URL).addHeader("Authorization", API_KEY).addHeader("content-type", "application/json").post(body).build();
        try (Response response = client.newCall(request).execute()) {
            String responseBody = response.body().string();
            System.out.println(responseBody);
            return responseBody;
        }
    }

    // 4.查询知识库详情
    public static String queryRepoDetail(String uid) throws IOException {
        // 构建请求URL和查询参数
        HttpUrl.Builder urlBuilder = HttpUrl.parse(REPO_DETAIL_URL).newBuilder().addQueryParameter("uid", uid).addQueryParameter("appId", APPID).addQueryParameter("sceneName", SCENE_NAME);
        String url = urlBuilder.build().toString();
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(url).addHeader("Authorization", API_KEY).addHeader("Content-Type", "application/json").get().build();
        try (Response response = client.newCall(request).execute()) {
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            String responseBody = response.body().string();
            // System.out.println("Response: " + responseBody);
            return responseBody;
        }
    }

    // 5.删除知识库或文档
    public static String deleteRepoOrFile(String uid, String groupId, String docId) throws IOException {
        // 构建完整的URL with query parameters
        HttpUrl.Builder urlBuilder = HttpUrl.parse(DELETE_REPO_URL).newBuilder().addQueryParameter("uid", uid).addQueryParameter("groupId", groupId).addQueryParameter("docId", docId);
        String url = urlBuilder.build().toString();
        OkHttpClient client = new OkHttpClient();
        // DELETE请求不需要请求体，参数都在URL中
        Request request = new Request.Builder().url(url).delete() // 使用DELETE方法
                .addHeader("Authorization", API_KEY).addHeader("Content-Type", "application/json").build();

        try (Response response = client.newCall(request).execute()) {
            // System.out.println(responseBody);
            assert response.body() != null;
            return response.body().string();
        }
    }


    // JSON数据解析
    class JsonParse1 {
        Data data;
    }

    class Data {
        String groupId;
    }

    // JSON数据解析2
    class JsonParse2 {
        Data2 data;
    }

    class Data2 {
        List<Repos> repos;
    }

    class Repos {
        String groupId;
        List<DocList> docList;
    }

    class DocList {
        String docid;
    }
}
