from pprint import pprint
import requests
import json
from datetime import datetime
from wsgiref.handlers import format_date_time
from time import mktime
import hashlib
import base64
import hmac
import time
from urllib.parse import urlparse
# API endpoint prefixes for different environments
PROD_API_PREFIX = "http://spark-openapi.cn-huabei-1.xf-yun.com"
class VoiceInsightClient:
    def __init__(self, api_key, api_secret):
        self.api_key = api_key
        self.api_secret = api_secret
    # build  auth request url
    def assemble_auth_header(self, request_url, method="GET"):
        u = urlparse(request_url)
        host = u.hostname
        path = u.path
        now = datetime.now()
        date = format_date_time(mktime(now.timetuple()))
        signature_origin = "host: {}\ndate: {}\n{} {} HTTP/1.1".format(host, date, method, path)
        signature_sha = hmac.new(self.api_secret.encode('utf-8'), signature_origin.encode('utf-8'),
                                digestmod=hashlib.sha256).digest()
        signature_sha = base64.b64encode(signature_sha).decode(encoding='utf-8')
        authorization_origin = "api_key=\"%s\", algorithm=\"%s\", headers=\"%s\", signature=\"%s\"" % (
            self.api_key, "hmac-sha256", "host date request-line", signature_sha)
        authorization = base64.b64encode(authorization_origin.encode('utf-8')).decode(encoding='utf-8')
        values = {
            "host": host,
            "date": date,
            "authorization": authorization,
        }
        return values
    def create(self, audio_file_url):
        req_url = "{}/api/v1/voice-insight/create".format(PROD_API_PREFIX)
        method = "POST"
        body = {
            "taskType": "audioFile",
            "audioFileURL": audio_file_url,
            "audioParams": {
                # "data_encoding":"lame"
            },
            "modelCode": "xdeepseekv31",
            "llmParams": {
                "enableThinking": True,
                "enableJsonResponse": True
            },
            "subTasks": [
                {
                    "is_customize": True,
                    "customize_prompt": "你将扮演中文咨询师质检员，对一段现场客服与患者的沟通进行结构化分析。对话内容为：${chat_content}。请基于该对话，从内容中提取核心信息，抽取的字段严格按照 ${ie_content} 中给出的字段名称和说明执行，并保持字段顺序一致。重要要求：如果同一字段中在对话里出现了多条信息（例如多个治疗方案、多次价格说明、多条后续建议、多个亲友/医保/居住信息等），必须在结果中全部列举出来，逐条清晰呈现，不能只保留一条或合并成笼统描述，也不能遗漏。只根据对话本身内容进行分析，不得臆测或补充对话中未出现的信息。最终输出必须为 JSON 列表格式。",
                    "name": "自定义分析-咨询分析",
                    "fields": [
                        {
                            "name": "患者信息",
                            "desc": "总结患者更多信息,帮助后续跟进,如亲友信息、居住情况、医保信息等(顾客是否本地医保/医保购买在哪里/哪里人/之前有没了解过牙齿相关信息/有在其他什么医院看过/住在什么区/过来需要多久时长/家里情况/是否认识员工/服用什么药物/身体有什么基础疾病...等等以此类推)"
                        },
                        {
                            "name": "主诉检查",
                            "desc": "患者主诉及咨询师口内检查出来的症状"
                        },
                        {
                            "name": "治疗方案",
                            "desc": "咨询师给患者介绍的治疗方案的概述,多个方案需要分别罗列,若会话中有提到治疗周期、耗材使用、方案优劣、价格明细(对应价格费用明细、优惠方案等)、付费情况(已成交什么项目,费用多少/未成交什么项目),则需要呈现出来"
                        },
                        {
                            "name": "补充说明",
                            "desc": "除了以上内容,其他有必要补充的说明"
                        },
                        {
                            "name": "后续建议",
                            "desc": "基于本次未成交/成交的场景,给到咨询师的具体跟进建议"
                        }
                    ]
                },
                {
                    "is_customize": True,
                    "customize_prompt": "你将扮演中文员工会话质检员，对一段现场客服与患者的沟通进行质检分析。对话内容为：${chat_content}。请基于该对话，从内容中提取核心质检信息，抽取字段严格按照 ${ie_content} 中给出的字段名称和说明执行，并保持字段顺序一致。重要要求：如果同一质检字段中，在对话里出现了多次相关行为或多条相关信息（例如多次主诉确认、多次影像解读、多次方案讲解或多种产品介绍、多种治疗方案优劣对比等），必须全部逐条列举出来，清晰区分不同条目，而不是合并成一句话或只保留一条示例。只依据对话真实内容进行判断和提取，不得进行主观臆造。最终输出必须为 JSON 列表格式。",
                    "name": "自定义分析-员工会话质检",
                    "fields": [
                        {
                            "name": "既往了解",
                            "desc": "既往了解(既往史采集)是指咨询师系统收集患者与口腔健康相关的历史信息,包括疾病、治疗和药物使用情况,以评估对口腔治疗的影响。具体需涵盖系统性疾病(如糖尿病、高血压)、过敏史(尤其麻醉药物和抗生素)、长期用药(如抗凝剂)、口腔手术史及家族遗传病史。这些信息可预判治疗风险,例如糖尿病患者需控制感染,高血压患者需监测术中血压。"
                        },
                        {
                            "name": "主诉确认",
                            "desc": "主诉确认是指咨询师通过系统询问和核实,准确掌握患者就诊的核心诉求和症状信息的过程,是建立有效医患沟通的重要环节。会话中咨询师有询问患者牙齿问题、确认症状发病时候、确认症状细节、确认症状区域等行为,则认为已执行该质检点。"
                        },
                        {
                            "name": "影像解读",
                            "desc": "影像解读是指咨询师通过口腔内扫描等影像资料向患者直接描述相关情况,帮助患者更直观地了解口腔问题。"
                        },
                        {
                            "name": "方案讲解",
                            "desc": "治疗方案讲解是咨询师根据患者的主诉、检查结果及影像资料,通过专业且通俗的沟通方式,向患者详细说明拟定的治疗计划。"
                        },
                        {
                            "name": "产品介绍",
                            "desc": "产品介绍是指咨询师向患者详细说明治疗中使用的材料、器械或修复体的特性、优势及注意事项,帮助患者做出知情决策。"
                        },
                        {
                            "name": "多方案优劣说明",
                            "desc": "当存在多个可行方案时,通过利弊分析、风险说明及个性化建议,帮助患者理解不同治疗路径的差异,辅助患者做出符合自身需求的决策。"
                        }
                    ]
                },
                {
                    "is_customize": True,
                    "customize_prompt": "你将扮演员工能力评估专员，对一段现场客服与患者的沟通进行员工能力评估。对话内容为：${chat_content}。请基于该对话，从中提取与能力评估相关的核心信息，抽取字段严格按照 ${ie_content} 中给出的字段名称和说明执行，并保持字段顺序一致。重要要求：如果在同一能力维度下出现了多种表现或多次典型话术（例如多个体现医学专业能力的解释、多轮需求挖掘问答、多次销售技巧运用、多次促单行为等），必须在结果中全部列举出来，逐条描述，不要简单合并成一句宽泛评价，也不要遗漏。请仅依据对话中真实出现的内容进行评估和举例，不得主观编造或扩写。最终输出必须为 JSON 列表格式。",
                    "name": "自定义分析-员工能力评估",
                    "fields": [
                        {
                            "name": "医疗专业能力",
                            "desc": "1.医学专业知识准确性:是否准确区分常见的口腔疾病、对治疗技术的原理阐释能力;2.方案解读深度:对治疗方案的解释是否全面、通俗易懂;3.风险告知专业性:告知的风险是否全面、客观、专业。"
                        },
                        {
                            "name": "需求挖掘能力",
                            "desc": "1.倾听有效性:专注倾听患者表达,深度理解患者表达的表面和潜在含义,及时做出正确积极的反馈;2.提问精准度:有逻辑、连贯的提出相关和有深度的问题,引导患者逐步深入表达;3.痛点与深层需求捕捉能力:精准识别患者痛点,挖掘与痛点相关的深层次需求。"
                        },
                        {
                            "name": "销售技巧能力",
                            "desc": "1.价值包装能力:运用生动形象的语言、案例、数据等突出诊疗方案对患者的独特价值;2.方案引导策略:引导患者理解、接受诊疗方案;3.异议化解水平:针对患者提出的价格、效果、安全性、适用性等各类疑惑和意见,及时、有效地进行回应和处理。"
                        },
                        {
                            "name": "促单提单能力",
                            "desc": "1.行动紧迫感营造:通过合理的策略和话术让患者意识到当下做出诊疗决策的必要性和紧迫性;2.关单时机把握:精准识别患者释放的成交信号,在恰当的时间节点主动推动成交流程;3.高效转化技巧:消除患者顾虑,推动完成订单签署。"
                        }
                    ]
                }
            ],
            "callBackUrl": "",
        }
        bds = json.dumps(body)
        values = self.assemble_auth_header(req_url, method=method)
        resp = requests.request(method, req_url, data=bds, params=values).text
        return resp
    def query(self, task_id):
        req_url = "{}/api/v1/voice-insight/tasks/{}".format(PROD_API_PREFIX, task_id)
        method = "GET"
        values = self.assemble_auth_header(req_url, method=method)
        resp = requests.request(method, req_url, params=values).text
        return resp
    
if __name__ == '__main__':
    voice_insight_client = VoiceInsightClient(api_key="XXXXXXXXXXXXXXXXXXXXX", api_secret="XXXXXXXXXXXXXXXXXXXXX")
    resp = voice_insight_client.create(audio_file_url="https://.....xx.wav")
    # print(resp.json())
    taskresult = json.loads(resp)
    if(0 ==taskresult['code'] ):
        taskid = taskresult['data']['task_id']
        while(1):
            queryresp= voice_insight_client.query(taskid)
            print(queryresp)
            res = json.loads(queryresp)
            if(res['data']['status']=='Finish' ):
                print("循环结束")
                break
            elif(res['data']['status']=='error' ):
                print("任务失败，请提供taskid 联系技术同事排查")
                break
            else:
                time.sleep(5)




