package com.black;

import com.black.constant.Constants;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import okhttp3.*;
import okio.ByteString;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

// 超拟人合成
public class AIMain extends WebSocketListener {
    public static String hostUrl = "https://cbm01.cn-huabei-1.xf-yun.com/v1/private/mcd9m97e6"; //http url 不支持解析 ws/wss schema
    public static Gson gson = new Gson();
    public static String TEXT_1 = "欢迎来到讯飞开放平台体验超拟人合成小助手";
    public static String TEXT_2 = "而我们所在的这个房间的高度呢，大约是3米";

    //发音人参数
    public static String VCN = "x5_lingfeiyi_flow";
    public static FileOutputStream fileOutputStream = null;
    public static File file = null;

    //main函数
    public static void main(String[] args) throws Exception {
        file = new File("src\\main\\resources\\out.pcm");
        fileOutputStream = new FileOutputStream(file);
        try {
            AIMain mainEntity = new AIMain();
            String ttsAuthUrl = getAuthUrl(hostUrl, Constants.API_KEY, Constants.API_SECRET);
            OkHttpClient client = new OkHttpClient.Builder().build();
            //将url中的 http://和https://分别替换为ws:// 和 wss://
            String url = ttsAuthUrl.toString().replace("http://", "ws://").replace("https://", "wss://");
            System.out.println(url);
            Request request = new Request.Builder().url(url).build();
            WebSocket webSocket = client.newWebSocket(request, mainEntity);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    class MyThread extends Thread {
        private WebSocket webSocket;

        public MyThread(WebSocket webSocket) {
            this.webSocket = webSocket;
        }

        @Override
        public void run() {
            //发送数据,求数据均为json字符串
            JsonObject sendData0 = new JsonObject();
            JsonObject header0 = new JsonObject();
            JsonObject parameter0 = new JsonObject();
            JsonObject payload0 = new JsonObject();
            //填充header0开始********************************************************
            header0.addProperty("app_id", Constants.APP_ID);
            header0.addProperty("status", 0); // 最后一帧就是2
            //填充header0结束********************************************************
            //填充parameter0开始********************************************************
            JsonObject oral0 = new JsonObject();
            oral0.addProperty("spark_assist", 1);
            oral0.addProperty("oral_level", "mid");

            JsonObject tts0 = new JsonObject();
            tts0.addProperty("vcn", VCN); // 发音人
            tts0.addProperty("speed", 50);
            tts0.addProperty("volume", 50);
            tts0.addProperty("pitch", 50);
            tts0.addProperty("bgs", 0);
            tts0.addProperty("reg", 0);
            tts0.addProperty("rdn", 0);
            tts0.addProperty("rhy", 0);
            tts0.addProperty("scn", 0);
            tts0.addProperty("version", 0);
            tts0.addProperty("L5SilLen", 1000);
            tts0.addProperty("ParagraphSilLen", 0);

            JsonObject audio0 = new JsonObject();
            audio0.addProperty("encoding", "raw");
            audio0.addProperty("sample_rate", 16000);
            audio0.addProperty("channels", 1);
            audio0.addProperty("bit_depth", 16);
            audio0.addProperty("frame_size", 0);
            JsonObject pybuf0 = new JsonObject();
            pybuf0.addProperty("encoding", "utf8");
            pybuf0.addProperty("compress", "raw");
            pybuf0.addProperty("format", "plain");

            tts0.add("audio", audio0);
            tts0.add("pybuf", pybuf0);

            parameter0.add("oral", oral0);
            parameter0.add("tts", tts0);
            //填充parameter0结束********************************************************
            //填充payload0开始********************************************************
            JsonObject text0 = new JsonObject();
            text0.addProperty("encoding", "utf8");
            text0.addProperty("compress", "raw");
            text0.addProperty("format", "json");
            text0.addProperty("status", 0);
            text0.addProperty("seq", 0);
            try {
                text0.addProperty("text", Base64.getEncoder().encodeToString(TEXT_1.getBytes("utf8")));
            } catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            JsonObject user_text0 = new JsonObject();
            user_text0.addProperty("encoding", "utf8");
            user_text0.addProperty("compress", "raw");
            user_text0.addProperty("format", "json");
            user_text0.addProperty("status", 0);
            user_text0.addProperty("seq", 0);
            try {
                user_text0.addProperty("text", Base64.getEncoder().encodeToString(TEXT_1.getBytes("utf8")));
            } catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            payload0.add("text", text0);
            // payload0.add("user_text", user_text0);
            //填充payload0结束********************************************************
            sendData0.add("header", header0);
            sendData0.add("parameter", parameter0);
            sendData0.add("payload", payload0);
            System.err.println(sendData0);
            webSocket.send(sendData0.toString()); // 第一次发送合成文本

            // 第二次：中间发送合成文本！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！
            //发送数据,求数据均为json字符串
            sendData0 = new JsonObject();
            header0 = new JsonObject();
            parameter0 = new JsonObject();
            payload0 = new JsonObject();
            //填充header0开始********************************************************
            header0.addProperty("app_id", Constants.APP_ID);
            header0.addProperty("status", 1); // 最后一帧就是2
            //填充header0结束********************************************************
            //填充parameter0开始********************************************************
            oral0 = new JsonObject();
            oral0.addProperty("spark_assist", 1);
            oral0.addProperty("oral_level", "mid");

            tts0 = new JsonObject();
            tts0.addProperty("vcn", VCN); // 发音人
            tts0.addProperty("speed", 50);
            tts0.addProperty("volume", 50);
            tts0.addProperty("pitch", 50);
            tts0.addProperty("bgs", 0);
            tts0.addProperty("reg", 0);
            tts0.addProperty("rdn", 0);
            tts0.addProperty("rhy", 0);
            tts0.addProperty("scn", 0);
            tts0.addProperty("version", 0);
            tts0.addProperty("L5SilLen", 1000);
            tts0.addProperty("ParagraphSilLen", 0);

            audio0 = new JsonObject();
            audio0.addProperty("encoding", "raw");
            audio0.addProperty("sample_rate", 16000);
            audio0.addProperty("channels", 1);
            audio0.addProperty("bit_depth", 16);
            audio0.addProperty("frame_size", 0);
            pybuf0 = new JsonObject();
            pybuf0.addProperty("encoding", "utf8");
            pybuf0.addProperty("compress", "raw");
            pybuf0.addProperty("format", "plain");

            tts0.add("audio", audio0);
            tts0.add("pybuf", pybuf0);

            parameter0.add("oral", oral0);
            parameter0.add("tts", tts0);
            //填充parameter0结束********************************************************
            //填充payload0开始********************************************************
            text0 = new JsonObject();
            text0.addProperty("encoding", "utf8");
            text0.addProperty("compress", "raw");
            text0.addProperty("format", "json");
            text0.addProperty("status", 1);
            text0.addProperty("seq", 1);
            try {
                text0.addProperty("text", Base64.getEncoder().encodeToString(TEXT_1.getBytes("utf8")));
            } catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            user_text0 = new JsonObject();
            user_text0.addProperty("encoding", "utf8");
            user_text0.addProperty("compress", "raw");
            user_text0.addProperty("format", "json");
            user_text0.addProperty("status", 1);
            user_text0.addProperty("seq", 1);
            try {
                user_text0.addProperty("text", Base64.getEncoder().encodeToString(TEXT_1.getBytes("utf8")));
            } catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            payload0.add("text", text0);
            // payload0.add("user_text", user_text0);
            //填充payload0结束********************************************************
            sendData0.add("header", header0);
            sendData0.add("parameter", parameter0);
            sendData0.add("payload", payload0);
            System.err.println(sendData0);
            webSocket.send(sendData0.toString()); // 第一次发送合成文本


            try {
                Thread.sleep(5000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            System.err.println(new Date() + "三次发送");
            //发送数据,求数据均为json字符串
            JsonObject sendData = new JsonObject();
            JsonObject header = new JsonObject();
            JsonObject parameter = new JsonObject();
            JsonObject payload = new JsonObject();
            //填充header开始********************************************************
            header.addProperty("app_id", Constants.APP_ID);
            header.addProperty("status", 2); // 最后一帧就是2
            //填充header结束********************************************************
            //填充parameter开始********************************************************
            JsonObject oral = new JsonObject();
            oral.addProperty("spark_assist", 1);
            oral.addProperty("oral_level", "mid");

            JsonObject tts = new JsonObject();
            tts.addProperty("vcn", VCN); // 发音人
            tts.addProperty("speed", 50);
            tts.addProperty("volume", 50);
            tts.addProperty("pitch", 50);
            tts.addProperty("bgs", 0);
            tts.addProperty("reg", 0);
            tts.addProperty("rdn", 0);
            tts.addProperty("rhy", 0);
            // tts.addProperty("scn", 0);
            // tts.addProperty("version", 0);
            // tts.addProperty("L5SilLen", 1000);
            // tts.addProperty("ParagraphSilLen", 0);

            JsonObject audio = new JsonObject();
            audio.addProperty("encoding", "raw");
            audio.addProperty("sample_rate", 24000);
            audio.addProperty("channels", 1);
            audio.addProperty("bit_depth", 16);
            audio.addProperty("frame_size", 0);
            JsonObject pybuf = new JsonObject();
            pybuf.addProperty("encoding", "utf8");
            pybuf.addProperty("compress", "raw");
            pybuf.addProperty("format", "plain");

            tts.add("audio", audio);
            parameter.add("tts", tts);
            //填充parameter结束********************************************************
            //填充payload开始********************************************************
            JsonObject text = new JsonObject();
            text.addProperty("encoding", "utf8");
            text.addProperty("compress", "raw");
            text.addProperty("format", "json");
            text.addProperty("status", 2);
            text.addProperty("seq", 0);
            try {
                text.addProperty("text", Base64.getEncoder().encodeToString(TEXT_2.getBytes("utf8")));
            } catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
       /* JsonObject user_text = new JsonObject();
        user_text.addProperty("encoding", "utf8");
        user_text.addProperty("compress", "raw");
        user_text.addProperty("format", "json");
        user_text.addProperty("status", 2);
        user_text.addProperty("seq", 1);
        try {
            user_text.addProperty("text", Base64.getEncoder().encodeToString(TEXT_2.getBytes("utf8")));
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }*/
            payload.add("text", text);
            // payload.add("user_text", user_text);
            //填充payload结束********************************************************
            sendData.add("header", header);
            sendData.add("parameter", parameter);
            sendData.add("payload", payload);
            System.err.println(sendData);
            webSocket.send(sendData.toString()); // 第二次发送合成文本
        }
    }

    @Override
    public void onOpen(WebSocket webSocket, Response response) {
        super.onOpen(webSocket, response);
        MyThread myThread = new MyThread(webSocket);
        myThread.start();
        //开启实时播放
        try {
          /*  Constants.TTS_SOURCE_DATA_LINE.open(Constants.TTS_AUDIO_FORMAT);
            Constants.TTS_SOURCE_DATA_LINE.start();*/
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println(response.body().string());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onMessage(WebSocket webSocket, String text) {
        super.onMessage(webSocket, text);
        //处理返回数据
        System.out.println(new Date() + "receive=>" + text);
        JsonParse myJsonParse = null;
        try {
            myJsonParse = gson.fromJson(text, JsonParse.class);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (myJsonParse.header.code != 0) {
            System.out.println("发生错误，错误码为：" + myJsonParse.header.code);
            System.out.println("本次请求的sid为：" + myJsonParse.header.sid);
        }
        if (myJsonParse.payload != null && myJsonParse.payload.audio != null && myJsonParse.payload.audio.audio != null) {
            try {
                byte[] textBase64Decode = Base64.getDecoder().decode(myJsonParse.payload.audio.audio);
                fileOutputStream.write(textBase64Decode);
                fileOutputStream.flush();
                /*Constants.TTS_SOURCE_DATA_LINE.write(textBase64Decode, 0, textBase64Decode.length); //实时写音频流*/
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (myJsonParse.header.status == 2) {
            try {
                fileOutputStream.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("返回status=2，合成完毕，文件保存路径为==>" + file.getPath());
          /*  Constants.TTS_SOURCE_DATA_LINE.stop();
            Constants.TTS_SOURCE_DATA_LINE.close();*/
            webSocket.close(0, "正常结束");
        }
    }

    @Override
    public void onMessage(WebSocket webSocket, ByteString bytes) {
        super.onMessage(webSocket, bytes);
    }

    @Override
    public void onClosing(WebSocket webSocket, int code, String reason) {
        super.onClosing(webSocket, code, reason);
        System.out.println("socket closing");
    }

    @Override
    public void onClosed(WebSocket webSocket, int code, String reason) {
        super.onClosed(webSocket, code, reason);
        System.out.println("socket closed");
    }

    @Override
    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        super.onFailure(webSocket, t, response);
        System.out.println("connection failed");
    }

    //签名鉴权加密
    public static String getAuthUrl(String hostUrl, String apiKey, String apiSecret) throws Exception {
        URL url = new URL(hostUrl);
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = format.format(new Date());
        StringBuilder builder = new StringBuilder("host: ").append(url.getHost()).append("\n").//
                append("date: ").append(date).append("\n").//
                append("GET ").append(url.getPath()).append(" HTTP/1.1");
        Charset charset = Charset.forName("UTF-8");
        Mac mac = Mac.getInstance("hmacsha256");
        SecretKeySpec spec = new SecretKeySpec(apiSecret.getBytes(charset), "hmacsha256");
        mac.init(spec);
        byte[] hexDigits = mac.doFinal(builder.toString().getBytes(charset));
        String sha = Base64.getEncoder().encodeToString(hexDigits);
        String authorization = String.format("hmac username=\"%s\", algorithm=\"%s\", headers=\"%s\", signature=\"%s\"", apiKey, "hmac-sha256", "host date request-line", sha);
        HttpUrl httpUrl = HttpUrl.parse("https://" + url.getHost() + url.getPath()).newBuilder().//
                addQueryParameter("authorization", Base64.getEncoder().encodeToString(authorization.getBytes(charset))).//
                addQueryParameter("date", date).//
                addQueryParameter("host", url.getHost()).//
                build();
        return httpUrl.toString();
    }

    //返回的json结果拆解
    class JsonParse {
        Header header;
        Payload payload;
    }

    class Header {
        int code;
        String sid;
        int status;
    }

    class Payload {
        Audio audio;
    }

    class Audio {
        String audio;
        int seq;
    }
}